/* $Id: tputhdr.h,v 1.4 1998/07/20 22:49:24 ericb Exp $ */
/* Copyright (C) 1995 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Bryan Murray */

#ifndef __tputhdr_h_INCLUDED__
#define __tputhdr_h_INCLUDED__ 1

/* This file provides a place to define a shared definition of an example
 * throughput header.  Most applications will want to add more information
 * to this structure -- but the information here allows the beginning of
 * data to be found, and which channels are available, as well as each
 * channels scale factor.  This is enough information to be able to process
 * the data later without knowing exactly how the data was recorded.  It is
 * important that if this structure is to be changed, that all changes be
 * made before any important data is recorded, as the record program and the
 * playback program need to be in sync as to what data is included in the
 * header.  If it is likely that changes will be made to this structure,
 * it might be a good idea to put a version field in the structure, and
 * to maintain all old structure definitions in this file so old data
 * can still be post-processed.
 */


/* Define the maximum number of input modules supported and the number of
 * channels per input module.
 *
 * NOTE: changing either of these numbers will mean that the example
 * throughput header defined below will change in size.  This may affect
 * the ability to playback any previously record data.  However, making
 * these values smaller will make the header smaller and save space on
 * the disk.
 */
#define MAX_MODULES             12
#define MAX_CHANNELS_PER_MODULE 16



/* This structure is an example of header information which can be written
 * at the beginning of the throughput file.  Other fields may be added here
 * if they are important to an application.  When adding a field here,
 * make sure to set the field appropriately in the function queryInputSetup()
 * in file tput.c or some other function which initializes the field.
 *
 * NOTE:  Changing this structure in any way may affect the ability to
 * playback data which has already been recorded.  The program writing
 * the header must agree with the program reading the header.
 */
typedef struct
{
    unsigned short channelCount;        /* total channels in group */
    unsigned short activeChanCount;     /* number channels recorded */
    unsigned short dataSize;            /* from e1432_get_data_size */
    unsigned short dataMode;            /* from e1432_get_data_mode */
    unsigned short appendStatusEnabled;
    unsigned short zoomEnabled;
    unsigned long  dataOffset;          /* file offset to recorded data */
    unsigned long  firstScanOffset;     /* accounts for wrapped file */
    unsigned long  samplesPerBlock;
    unsigned long  scanCount;
                                        /* scale==0 if channel disabled */
    double         scaleFactor[MAX_MODULES * MAX_CHANNELS_PER_MODULE];
    double         span;
    double         centerFreq;
} InputHwInformation;

#endif /* __tputhdr_h_INCLUDED__ */
